;REPLAYER:	include "sound\PT3-ROM.ASM"
    include "sound\pt3ROM.ASM"
   ; block 100,0

;   if NTSC=0

music01:      incbin "sound\gameMusic1.pt3.mlz"
    ;block 100,0
music02:      incbin "sound\gameMusic2.pt3.mlz"
;    block 100,0
music03:      incbin "sound\gameMusic4.pt3.mlz"
;    block 100,0
music04:      incbin "sound\gameMusic3.pt3.mlz"
;    block 100,0
music05:      incbin "sound\gameMusic5.pt3.mlz"
    ;block 100,0
music06:      incbin "sound\gameMusic6.pt3.mlz"
;    block 100,0
ending:      incbin "sound\ending.pt3.mlz"
;    block 100,0
menu:      incbin "sound\menu.pt3.mlz"
;    block 100,0
nullMusic: incbin "sound\nullMusic.pt3",99

;    else


music01n:      incbin "sound\gameMusic1+.pt3.mlz"
    ;block 100,0
music02n:      incbin "sound\gameMusic2+.pt3.mlz"
;    block 100,0
music03n:      incbin "sound\gameMusic4+.pt3.mlz"
;    block 100,0
music04n:      incbin "sound\gameMusic3+.pt3.mlz"
;    block 100,0
music05n:      incbin "sound\gameMusic5+.pt3.mlz"
    ;block 100,0
music06n:      incbin "sound\gameMusic6+.pt3.mlz"
;    block 100,0
endingn:      incbin "sound\ending+.pt3.mlz"
;    block 100,0
menun:      incbin "sound\menu+.pt3.mlz"

    include "sound\ayfxROM.ASM"

music:  dw music01,music02,music03,music04
        dw music01,music02,music03,music04
        dw music01,music02      
        dw music06,music02,music06,music02,music06
        dw music05,music03,music05,music06,music05
        dw ending     

musicNTSC:  dw music01n,music02n,music03n,music04n
        dw music01n,music02n,music03n,music04n
        dw music01n,music02n      
        dw music06n,music02n,music06n,music02n,music06n
        dw music05n,music03n,music05n,music06n,music05n
        dw endingn          

SFXDATA:	incbin "sound\sfx.afb"    
initAYFX:
    ld hl,SFXDATA : call ayFX_SETUP
    ret
initMenuMusic:
        di
        ;ld		hl,menu-99			; hl <- initial address of module - 99    
        ld hl,menu : ld de,musicBuffer : call DEC40
        ld a,(is60)    
        cp 1
        jr nz,1f
        ld hl,menun : ld de,musicBuffer : call DEC40
1:
        ;kill 99 bytes
        ld hl,musicBuffer : ld de,musicBuffer+1 : ld bc,98 : ld (hl),0 : ldir
        ld hl,musicBuffer
		call	PT3_INIT			; Inits PT3 player
        ld a,(PT3_SETUP) : res 0,a : ld (PT3_SETUP),a		
        ei
    ret

initMusic:
        di
        ld hl,music 
        ld a,(is60)    
        cp 1
        jr nz,1f
        ld hl,musicNTSC
1:


        ld a,(currentLevel) : dec a : add a,a : ld c,a : ld b,0
        add hl,bc
        ld a,(hl): inc hl : ld h,(hl) :ld l,a

        ld de,musicBuffer : call DEC40
        ;kill 99 bytes
        ld hl,musicBuffer : ld de,musicBuffer+1 : ld bc,98 : ld (hl),0 : ldir
        ld hl,musicBuffer
		;ld		hl,music03-99			; hl <- initial address of module - 99        
		call	PT3_INIT			; Inits PT3 player
        ld a,(PT3_SETUP) : res 0,a : ld (PT3_SETUP),a		
        ei
    ret

muteMusic:
        halt
        di        
        call	PT3_ROUT;write to AY from AY_REGS
        ld		hl,nullMusic-99			; hl <- initial address of module - 99        
		call	PT3_INIT			; Inits PT3 player                
		call	PT3_PLAY;play to AY_REGS
        call ayFX_PLAY
        ;ld a,(PT3_SETUP) : res 0,a : ld (PT3_SETUP),a		
        ;call PT3_PLAY
        ;call PT3_MUTE
        ei
                
    ret

AFXPLAY3:
    
    di : ld c,0 : call ayFX_INIT : ei
    ret


playMineSound:
     ld a,11
    call AFXPLAY3
    ret

playBumSound:
    ld a,12
    call AFXPLAY3
    ret

playMostSound:
    ld a,(mostSoundCount) : inc a : and 1 : ld (mostSoundCount),a
    add 9
    call AFXPLAY3
    ret

playCollectSound2:
    ld a,7 : call AFXPLAY3
    ret

playCollectSound:
    ld a,8 : call AFXPLAY3
    ret


playPutBlockSound:
    ld a,5 : call AFXPLAY3
    ret

playHideBlockSound:
    ld a,6 : call AFXPLAY3
    ret

checkStartFall:
    ld a,(heroPreState)
    cp HERO_FALL
    ret z
    ld a,2 : call AFXPLAY3
    ret

checkLand:
    ld a,(heroState)
    cp HERO_FALL
    ret z
    ld a,1 : call AFXPLAY3
    ret

doHeroSounds:
    //start fall
    ld a,(heroState)
    cp HERO_FALL
    call z,checkStartFall

    //land
    ld a,(heroPreState)
    cp HERO_FALL
    call z,checkLand

    ld a,(heroState)
    cp HERO_IDLE
    ret z

    cp HERO_MOVE_UP
    jp z,ladderSound
    cp HERO_MOVE_DOWN
    jp z,ladderSound

    cp HERO_MOVE_LEFT
    jp z,walkSound
    cp HERO_MOVE_RIGHT
    jp z,walkSound
    cp HERO_FALL
    jp z,fallSound


    ret	

fallSound:
    ld a,(heroMoveCount)
    cp 3
    ret nz
    ld a,0 : call AFXPLAY3
    ret


ladderSound:
    ld a,(heroMoveCount)
    cp 7
    ret nz
    ld a,3 : call AFXPLAY3
    ret


walkSound:
    ld a,(heroMoveCount)
    cp 7
    ret nz
    ld a,(walkSoundCount)
    inc a : and 1
    ld (walkSoundCount),a
    add 3
    ;ld a,4 : call AFXPLAY
    call AFXPLAY3
    ret
